UUID=`uuidgen -t`
WORKDIR="/tmp/$UUID/"
mkdir -p $WORKDIR
git clone https://github.com/mysql/mysql-server.git
cd ./mysql-docker/mysql-cluster/8.0/

sed -i 's|COPY cnf/my.cnf /etc/|RUN ln -f -s /config/my.cnf /etc/my.cnf|' Dockerfile
sed -i 's|COPY cnf/mysql-cluster.cnf /etc/|RUN ln -f -s /config/mysql-cluster.cnf /etc/mysql-cluster.cnf|' Dockerfile

# Write custom my.cnf, for /etc/my.cnf in image
cat << EOF > /admacs/mysql_config/my.cnf
[mysqld]
ndbcluster
ndb-connectstring=192.168.0.11,192.168.0.12,192.168.0.13,192.168.0.14
user=mysql

[mysql_cluster]
ndb-connectstring=192.168.0.11,192.168.0.12,192.168.0.13,192.168.0.14
EOF

# Write custom mysql-cluster.cnf, for /etc/mysql-cluster.cnf in image
cat << EOF > /admacs/mysql_config/mysql-cluster.cnf
[ndbd default]
NoOfReplicas=4
DataMemory=80M
IndexMemory=18M

[ndb_mgmd]
NodeId=1
hostname=192.168.0.11
datadir=/var/lib/mysql

[ndb_mgmd]
NodeId=2
hostname=192.168.0.12
datadir=/var/lib/mysql

[ndb_mgmd]
NodeId=3
hostname=192.168.0.13
datadir=/var/lib/mysql

[ndb_mgmd]
NodeId=4
hostname=192.168.0.14
datadir=/var/lib/mysql

[ndbd]
NodeId=5
hostname=192.168.0.21
datadir=/var/lib/mysql

[ndbd]
NodeId=6
hostname=192.168.0.22
datadir=/var/lib/mysql

[ndbd]
NodeId=7
hostname=192.168.0.23
datadir=/var/lib/mysql

[ndbd]
NodeId=8
hostname=192.168.0.24
datadir=/var/lib/mysql

[mysqld]
NodeId=9
hostname=192.168.0.31

[mysqld]
NodeId=10
hostname=192.168.0.32

[mysqld]
NodeId=11
hostname=192.168.0.33

[mysqld]
NodeId=12
hostname=192.168.0.34

EOF


#https://hub.docker.com/r/mysql/mysql-cluster/
#Setup a network for the MySQL containers
sudo podman network create cluster --subnet=192.168.0.0/24

#Setup the Management nodes
sudo podman run -d --net=cluster --name=management1 --ip=192.168.0.11 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndb_mgmd
sudo podman run -d --net=cluster --name=management2 --ip=192.168.0.12 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndb_mgmd
sudo podman run -d --net=cluster --name=management3 --ip=192.168.0.13 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndb_mgmd
sudo podman run -d --net=cluster --name=management4 --ip=192.168.0.14 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndb_mgmd

#Setup the Data nodes
sudo podman run -d --net=cluster --name=ndb1 --ip=192.168.0.21 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndbd
sudo podman run -d --net=cluster --name=ndb2 --ip=192.168.0.22 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndbd
sudo podman run -d --net=cluster --name=ndb3 --ip=192.168.0.23 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndbd
sudo podman run -d --net=cluster --name=ndb4 --ip=192.168.0.24 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 ndbd

#Setup the Storage nodes
sudo podman run -d --net=cluster --name=mysql1 --ip=192.168.0.31 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 mysqld
sudo podman run -d --net=cluster --name=mysql2 --ip=192.168.0.32 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 mysqld
sudo podman run -d --net=cluster --name=mysql3 --ip=192.168.0.33 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 mysqld
sudo podman run -d --net=cluster --name=mysql4 --ip=192.168.0.34 -v /home/evan/container_test:/config:Z mysql/mysql-cluster:8.0 mysqld

for i in $(seq 1 4); do
	CONAINTER="mysql$i"
	PWORD=""
	while [[ "$PWORD" == "" ]];  do
		PWORD=`sudo podman logs $CONTAINER 2>&1 | grep PASSWORD | awk '{print $5}'`
	done
	sudo podman exec -it $CONTAINER mysql -uroot -p$PWORD1 -e "ALTER USER 'root'@'localhost' IDENTIFIED BY 'aaaaaa';"
done


sudo podman run -it --net=cluster mysql/mysql-cluster ndb_mgm

